C      *****************************************************************
C      * Subroutine CheckIndex                                         *
C      * Checks if all species of interest are present in the soil     *
C      * model.  If they are, the variable GoAhead is returned         *
C      * indicating this.  If they are not, the user is alerted to this*
C      * fact and can choose whether the model should continue or not. *
C      * GoAhead is returned indicating the user's choice.             *
C      *                                                               *
C      * Variables:                                                    *
C      * Ans       -Local - Contains the user's response to a prompt.  *
C      *                    Unitless.                                  *
C      * GoAhead   -Output- Indicates whether the soil chemistry model *
C      *                    is to continue based on the correspondence *
C      *                    between the species of interest to the     *
C      *                    tree model and the species in the soil     *
C      *                    model.  The user may choose to continue    *
C      *                    the soil model even if all species of      *
C      *                    interest are not present.  (GoAhead=1 means*
C      *                    that all species of interest are present or*
C      *                    the user wants to continue; GoAhead=0 means*
C      *                    that all species of interest are not       *
C      *                    present.)   Unitless.                      *
C      * I         -Local - Array index.  Unitless.                    *
C      * SpIndex   -Input - A vector, of size SpNum, of indices into   *
C      *                    arrays which match each species of         *
C      *                    interest.  SpIndex(i) is an index that when*
C      *                    used in the Labels array will give the     *
C      *                    name of the species amount the tree has    *
C      *                    consumed is NuTake(i).  SpIndex(i) when    *
C      *                    used as the index into SpConc will give the*
C      *                    concentration of this species.  Input from *
C      *                    TREGRO, or read into the model by the      *
C      *                    routine InParam.  Unitless.                *
C      *                    (Common block VIF, file VModel.f)          *
C      * SpNum     -Output- The number of species of interest.  Input  *
C      *                    from TREGRO, or read into the model by the *
C      *                    routine InParam.  Unitless.                *
C      *                    (Common block VIF, file VModel.f)          *
C      * StndAlone -Input - Indicates whether soil model is running as *
C      *                    a stand alone model (TRUE) or not (FALSE). * 
C      *                    Unitless.                                  *
C      *                    (Common block VModel, file VModel.f)       *
C      *****************************************************************
       SUBROUTINE CHECKINDEX(GOAHEAD)
							IMPLICIT NONE
							INCLUDE 'VMODEL.INC'
							INTEGER GOAHEAD, I
							CHARACTER ANS
							
C      *------------------------------------------------------------------*
C      * Check if all species of interest are contained in the soil model.*
C      *------------------------------------------------------------------*
       GOAHEAD = 1
       DO 100 I=1, SPNUM
	         IF (SPINDEX(I).EQ.-1) GOAHEAD = 0
  100  CONTINUE
  
C      *-----------------------------------------------------------------*
C      * If all species of interest are contained in the soil model then *
C      * this is indicated by the variable GoAhead.  If they are not all *
C      * contained in the soil model then alert the user to this and let *
C      * the user choose whether the soil model should continue.         *
C      *-----------------------------------------------------------------*
       IF (GOAHEAD.EQ.0) THEN
	         WRITE(6,*)
										WRITE(6,*) 'Not all species required by the tree are '
          WRITE(6,*) 'contained in the soil chemistry model.  '
										WRITE(6,*) 'Continue? (y/n): '
										READ(6,*)   ANS
										IF ((ANS.EQ.'Y').OR.(ANS.EQ.'y')) GOAHEAD = 1
	     	ENDIF
       	   
       RETURN
	      END
C      *****************************************************************
C      *                    END SUBROUTINE                             *
C      *****************************************************************
     